/*
 * Decompiled with CFR 0.152.
 */
package com.daehome.app;

import com.daehome.model.DeviceTableModel;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.Selector;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JButton;
import javax.swing.SwingWorker;
import org.json.JSONObject;

public class MulticastDiscovery
extends SwingWorker<Void, String> {
    private static final String MULTICAST_HOST = "236.1.6.8";
    private static final int MULTICAST_PORT = 16888;
    private static final int SERVER_MULTICAST_PORT = 16880;
    private InetAddress multicastGroup;
    private InetSocketAddress multicastInetSocketAddress;
    private InetSocketAddress serverMulticastInetSocketAddress;
    private Selector selector;
    private DeviceTableModel model;
    private JButton source;
    private int time;

    private MulticastDiscovery() {
    }

    public MulticastDiscovery(DeviceTableModel model, JButton source) {
        this(model, source, 3000);
    }

    public MulticastDiscovery(DeviceTableModel model, JButton source, int time) {
        this.model = model;
        this.source = source;
        this.time = time;
        try {
            this.multicastGroup = InetAddress.getByName(MULTICAST_HOST);
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(MulticastDiscovery.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.multicastInetSocketAddress = new InetSocketAddress(this.multicastGroup, 16888);
        this.serverMulticastInetSocketAddress = new InetSocketAddress(this.multicastGroup, 16880);
    }

    public String aesDecryptContent(String content) {
        String originKey = "!3093059";
        String resultContent = "";
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] digest = md5.digest(originKey.getBytes(StandardCharsets.UTF_8));
            String md5Key = IntStream.range(0, digest.length).mapToObj(i -> String.format("%02X", 0xFF & digest[i])).collect(Collectors.joining(""));
            String key = md5Key.substring(md5Key.length() - cipher.getBlockSize());
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "AES");
            cipher.init(2, secretKey);
            byte[] b = cipher.doFinal(Base64.getDecoder().decode(content));
            resultContent = Objects.isNull(b) ? "" : new String(b, StandardCharsets.UTF_8).trim();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            Logger.getLogger(MulticastDiscovery.class.getName()).log(Level.SEVERE, null, ex);
        }
        return resultContent;
    }

    public void searchDevice(List<NetworkInterface> networkInterface, MulticastSocket ms, SocketAddress socketAddress) throws IOException {
        HashSet<String> gatewaySet = new HashSet<String>();
        System.err.println("socketAddress = " + socketAddress);
        networkInterface.forEach(ni -> {
            try {
                ms.joinGroup(socketAddress, (NetworkInterface)ni);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
        ms.setSoTimeout(this.time);
        byte[] b = new byte[1024];
        while (!this.isCancelled()) {
            DatagramPacket dp = new DatagramPacket(b, b.length);
            ms.receive(dp);
            String recv = this.aesDecryptContent(new String(dp.getData(), 0, dp.getLength(), StandardCharsets.UTF_8));
            if (gatewaySet.contains(recv)) break;
            gatewaySet.add(recv);
            this.publish(recv);
        }
        networkInterface.forEach(ni -> {
            try {
                ms.leaveGroup(socketAddress, (NetworkInterface)ni);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
    }

    @Override
    protected Void doInBackground() throws Exception {
        Throwable throwable;
        MulticastSocket ms;
        List<NetworkInterface> multicastNetworkInterfaceList = Collections.list(NetworkInterface.getNetworkInterfaces()).stream().filter(ni -> {
            try {
                boolean isIPv4 = Collections.list(ni.getInetAddresses()).stream().filter(ia -> ia instanceof Inet4Address).collect(Collectors.toList()).size() > 0;
                return isIPv4 && !ni.isLoopback() && !ni.isVirtual() && ni.isUp() && ni.supportsMulticast();
            }
            catch (SocketException ex) {
                throw new UncheckedIOException(ex);
            }
        }).collect(Collectors.toList());
        this.model.setRowCount(0);
        try {
            ms = new MulticastSocket(16880);
            throwable = null;
            try {
                this.searchDevice(multicastNetworkInterfaceList, ms, this.serverMulticastInetSocketAddress);
                ms.close();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ms != null) {
                    if (throwable != null) {
                        try {
                            ms.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ms.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MulticastDiscovery.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        try {
            ms = new MulticastSocket(16888);
            throwable = null;
            try {
                this.searchDevice(multicastNetworkInterfaceList, ms, this.multicastInetSocketAddress);
                ms.close();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ms != null) {
                    if (throwable != null) {
                        try {
                            ms.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ms.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MulticastDiscovery.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        return null;
    }

    @Override
    protected void process(List<String> device) {
        for (String jsonString : device) {
            if (this.isCancelled()) break;
            JSONObject json = new JSONObject(jsonString);
            this.model.addRow(new Object[]{json.get("mac"), json.get("ip"), json.get("version"), json.get("model")});
        }
    }

    @Override
    protected void done() {
        this.setProgress(100);
        this.source.setEnabled(true);
    }
}

